function [pc_roi] = convert_to_point_cloud(x_crop,y_crop,cs_corrected_roi)

% used to convert circular symmetry corrected cartridge case to point cloud
%% input
% x_crop : x values for tightly cropped region of interest
% y_crop : y values for tightly cropped region of interest
% cs_corrected_roi : circular symmetry corrected z values for tightly cropped region of interest 

%% output
% pc_roi : point cloud of the tightly cropped region of interest

rX1=repmat(x_crop,[1 length(y_crop)]);
rX=reshape(rX1,[length(x_crop)*length(y_crop) 1]);

rY1=repmat(y_crop,[length(x_crop) 1]);
rY=reshape(rY1,[length(x_crop)*length(y_crop) 1]);

rZ=reshape(cs_corrected_roi,[length(x_crop)*length(y_crop) 1]);

pc_roi=pointCloud([rX rY rZ]);
end

